/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.recipe_book_categories;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1860;
import net.minecraft.class_314;
import net.minecraft.class_3956;
import net.minecraft.class_5421;
import org.jetbrains.annotations.Nullable;

public class RecipeBookRegistry {
    public static final Map<class_314, List<class_314>> AGGREGATE_CATEGORIES = new HashMap<class_314, List<class_314>>();
    private static final Map<class_5421, List<class_314>> TYPE_CATEGORIES = new HashMap<class_5421, List<class_314>>();
    private static final Map<class_3956<?>, Function<class_1860<?>, class_314>> RECIPE_CATEGORY_LOOKUPS = new HashMap();

    @Nullable
    public static <T extends class_1860<?>> class_314 findCategories(class_3956<T> type, T recipe) {
        Function<class_1860<?>, class_314> lookup = RECIPE_CATEGORY_LOOKUPS.get(type);
        return lookup != null ? lookup.apply(recipe) : null;
    }

    @Nullable
    public static List<class_314> getCustomCategoriesOrNull(class_5421 recipeBookType) {
        return TYPE_CATEGORIES.getOrDefault(recipeBookType, null);
    }

    public static void registerAggregateCategory(class_314 category, List<class_314> others) {
        AGGREGATE_CATEGORIES.put(category, (List<class_314>)ImmutableList.copyOf(others));
    }

    public static void registerBookCategories(class_5421 type, List<class_314> categories) {
        TYPE_CATEGORIES.put(type, (List<class_314>)ImmutableList.copyOf(categories));
    }

    public static void registerRecipeCategoryFinder(class_3956<?> type, Function<class_1860<?>, class_314> lookup) {
        RECIPE_CATEGORY_LOOKUPS.put(type, lookup);
    }
}

